'use strict';
'require view';
'require form';
'require uci';
'require fs';
'require rpc';
'require ui';
'require dom';

function initRemoteGPIOState() {
    return L.resolveDefault(uci.load("RemoteGPIO"));
}

function getConfigData() {
    return initRemoteGPIOState().then(
        L.bind(function(){
            // Reading from Config File, Reading from Custom File, Writing to Config File, Syncing to UI - Reference Code
            return fs.read('/sys/class/gpio/gpio480/value').then( function(customValue){ 
                
                var gpioConfig480 = uci.get("RemoteGPIO","INPUT0", "value");
                
                console.log("Value GPIO 480 Custom File = " + customValue);
                console.log("Value GPIO 480 Config File = " + gpioConfig480);

                if(gpioConfig480 != customValue) {
                    uci.set('RemoteGPIO','INPUT0', 'value', customValue);
                    uci.save();
                } 
                
                return fs.read('/sys/class/gpio/gpio481/value').then( function(customValue){ 
                    
                    var gpioConfig481 = uci.get("RemoteGPIO","INPUT1", "value");
                    
                    console.log("Value GPIO 481 Custom File = " + customValue);
                    console.log("Value GPIO 481 Config File = " + gpioConfig481);
    
                    if(gpioConfig481 != customValue) {
                        uci.set('RemoteGPIO','INPUT1', 'value', customValue);
                        uci.save();
                    }   

                    return fs.read('/sys/class/gpio/gpio482/value').then( function(customValue){ 
                        var gpioConfig482 = uci.get("RemoteGPIO","INPUT2", "value");
                        
                        console.log("Value GPIO 482 Custom File = " + customValue);
                        console.log("Value GPIO 482 Config File = " + gpioConfig482);
        
                        if(gpioConfig482 != customValue) {
                            uci.set('RemoteGPIO','INPUT2', 'value', customValue);
                            uci.save();
                        }   

                        return fs.read('/sys/class/gpio/gpio483/value').then( function(customValue){ 
                            var gpioConfig483 = uci.get("RemoteGPIO","INPUT3", "value");
                            
                            console.log("Value GPIO 483 Custom File = " + customValue);
                            console.log("Value GPIO 483 Config File = " + gpioConfig483);
            
                            if(gpioConfig483 != customValue) {
                                uci.set('RemoteGPIO','INPUT3', 'value', customValue);
                                uci.save();
                            }     
                            return true;
                        });
                    });
                });
            });
        })
    )
}

return view.extend({
    // Add Custom Handler for Saving Data
    handleSave: function() {
        var map = document.querySelector('.cbi-map');
        return dom.callClassMethod(map, 'save').then(function() {

            var mapData = dom.data(map);

            mapData._class.data.loaded.RemoteGPIO.then( value => {
                var formData = value;
                console.log(formData)

                // Custom Console Log - Remove Later
                console.log("Value for for VOUT1_gpio2_25 = " + formData.VOUT1_gpio2_25.value);
                console.log("Value for for VOUT1_gpio2_26 = " + formData.VOUT3_gpio2_26.value);
                console.log("Value for for VOUT1_gpio2_27 = " + formData.VOUT2_gpio2_27.value);
                console.log("Value for for VOUT1_gpio2_28 = " + formData.VOUT4_gpio2_28.value);

                // Setting Configuration File - Output
                uci.set('RemoteGPIO','VOUT1_gpio2_25', 'value', formData.VOUT1_gpio2_25.value);
                uci.set('RemoteGPIO','VOUT1_gpio2_26', 'value', formData.VOUT3_gpio2_26.value);
                uci.set('RemoteGPIO','VOUT1_gpio2_27', 'value', formData.VOUT2_gpio2_27.value);
                uci.set('RemoteGPIO','VOUT1_gpio2_28', 'value', formData.VOUT4_gpio2_28.value);

                // Writing to Custom Files - Output
                fs.write('/sys/class/gpio/gpio121/value',formData.VOUT1_gpio2_25.value).then(function (rc) {
                        if(!rc) {
                            console.log("Success Writing to File - /sys/class/gpio/gpio121/value = " + formData.VOUT1_gpio2_25.value)
                        }
                    }, (error) => {
                        console.log(error);
                });
                fs.write('/sys/class/gpio/gpio122/value',formData.VOUT3_gpio2_26.value).then(function (rc) {
                    if(!rc) {
                        console.log("Success Writing to File - /sys/class/gpio/gpio122/value = " + formData.VOUT1_gpio2_26.value)
                    }
                }, (error) => {
                    console.log(error);
                });
                fs.write('/sys/class/gpio/gpio123/value',formData.VOUT2_gpio2_27.value).then(function (rc) {
                    if(!rc) {
                        console.log("Success Writing to File - /sys/class/gpio/gpio123/value = " + formData.VOUT1_gpio2_27.value)
                    }
                }, (error) => {
                    console.log(error);
                });
                fs.write('/sys/class/gpio/gpio124/value',formData.VOUT4_gpio2_28.value).then(function (rc) {
                    if(!rc) {
                        console.log("Success Writing to File - /sys/class/gpio/gpio124/value = " + formData.VOUT1_gpio2_28.value)
                    }
                }, (error) => {
                    console.log(error);
                });

                // Save Updated Inputs/Data
                return uci.save().then(L.bind(ui.changes.init, ui.changes)).then(L.bind(ui.changes.apply, ui.changes));
            });
        });
    },
    render: function() {

        var m;

        const inputZero = getConfigData();

        var m = inputZero.then(function(result){
            
            console.log(result);

            var m, s, o;

            m = new form.Map('RemoteGPIO', 'Configuration - RemoteGPIO');
            
            s = m.section(form.TypedSection, 'in', _("Input"), "Values Rendered Below are the updated values of /sys/class/gpio/gpio$(num)/value ");
            s.anonymous = false;
            s.tabbed = true;
            
            o = s.option(form.Value, "name", "Name")
            o.readonly = true;

            // o = s.option(form.Value, "num", "Num")
            // o.readonly = true;

            o = s.option(form.Value, "value", "Value")
            o.readonly = true;

            s = m.section(form.GridSection, 'out', _("Output"), "Click on 'Edit' and input value to write to /sys/class/gpio/gpio$(num)/value");
            s.anonymous = true;
            s.sortable = true;

            o = s.option(form.Value, "name", "Name")
            // o = s.option(form.Value, "num", "Num")
            o = s.option(form.Value, "value", "Value")

            s = m.section(form.GridSection, "nets", _("Nets"));
			s.anonymous = true;
			s.addremove = true;
            s.sortable = true;
            
            o = s.option(form.Value, "name", "Nets")
			o = s.option(form.Value, "type", "Type")
			o.rmempty = false;
			o.value("tcp",_("tcp"))
			o.value("tcp6",_("tcp6"))
			o.value("udp",_("udp"))
			o.value("udp6",_("udp6"))
			o.value("tcp-listen",_("tcp-listen"))
			o.value("tcp6-listen",_("tcp6-listen"))
			o.value("udp-listen",_("udp-listen"))
			o.value("udp6-listen",_("udp6-listen"))
			o = s.option(form.Value, "local_port", "Local Port")
			o = s.option(form.Value, "ssl", "SSL")
			o.rmempty = false;
			o.value("true",_("true"))
			o.value("false",_("false"))
			o = s.option(form.Value, "ssl_verify", "SSL Verify")
			o.rmempty = false;
			o.value("true",_("true"))
			o.value("false",_("false"))
			o = s.option(form.Value, "cert_file", "Cert File")
			o = s.option(form.Value, "ca_file", "CA File")
			o = s.option(form.Value, "remote_addr", "Remote Address")
			o = s.option(form.Value, "remote_port", "Remote Port")


            console.log(o);

            return m.render()
        })

        return m;
    },
    handleSaveApply: null,
    handleReset: null,
});