'use strict';
'require uci';
'require rpc';
'require view';
'require form';
'require dom';
'require ui';
'require tools.widgets as widgets';

function initRemoteGPIOState() {
    return L.resolveDefault(uci.load("SerOverNet"));
}

function getDynamicConfig(){
	return initRemoteGPIOState()
	.then(
		L.bind(function(){
			var config = uci.sections("SerOverNet");
			return config;
		})
	)
}

return view.extend({

	render: function() {

		const dynamicConfig = getDynamicConfig();

		var m = dynamicConfig.then(function(result){

			console.log(result);

			//var countObjectLength = Object.keys(result).length;

			var dataSerials = [];
			var dataNets = [];

			var resultNew = result.filter(value => {
				var receivedData = value;
				if(receivedData[".type"] === 'serial'){
					dataSerials.push(receivedData.name)
				}
				else if(receivedData[".type"] === 'nets'){
					dataNets.push(receivedData.name)
				}
			});

			console.log(dataSerials);
			console.log(dataNets);

			var m, s, o;
			
			m = new form.Map('SerOverNet', 'SerOverNet');
			

			//SerOverNet
			s = m.section(form.TypedSection, "globals", _("General"));
			s.anonymous = true;

			o = s.option(form.DummyValue, "globals", _("Globals: "))
			o.rmempty = false
			o.cfgvalue = function(section_id) {
				return section_id ;
			};

			o = s.option(form.Value, "interval", _("Reconnect Interval (>=0): "))
			o.rmempty = false

			o = s.option(form.Value, "overtime", _("Lifetime (>=0): "))
			o.rmempty = false

			//SerOverNet
			// s = m.section(form.TypedSection, "serial", _("Serial"));
			s = m.section(form.GridSection, 'serial', _("Serial"));
			s.anonymous = true;
			s.sortable = true;

			o = s.option(form.DummyValue, "name", "Name")

			console.log("dataSerials =>" + dataSerials)
			o = s.option(form.DummyValue, "device", "Device")
			o = s.option(form.ListValue, "baudrate", "Baud Rate")
			o.rmempty = false;
			o.value("9600",_("9600"))
			o.value("19200",_("19200"))
			o.value("38400",_("38400"))
			o.value("57600",_("57600"))
			o.value("115200",_("115200"))
			o.value("230400",_("230400"))
			o.value("460800",_("460800"))
			o.value("921600",_("921600"))
			o.value("1500000",_("1500000"))
			o.default = "9600"
			o = s.option(form.Value, "databits", "Data Bits")
			o.rmempty = false;
			o.value(5)
			o.value(6)
			o.value(7)
			o.value(8)
			o.default = 5
			o = s.option(form.Value, "stopbits", "Stop Bits")
			o.rmempty = false;
			o.value(1)
			o.value(2)
			o = s.option(form.Value, "parity", "Parity")
			o.value("NOPARITY",_("NO PARITY"))
			o.value("ODD_PARITY",_("ODD PARITY"))
			o.value("EVEN PARITY",_("EVEN PARITY"))
			o.default = "NOPARITY"
			o = s.option(form.DummyValue, "DERE", "DE/RE")
			
			s = m.section(form.GridSection, "nets", _("Nets"));
			s.anonymous = true;
			s.addremove = true;
			s.sortable = true;

			o = s.option(form.Value, "name", "Nets")
			o = s.option(form.Value, "type", "Type")
			o.rmempty = false;
			o.value("tcp",_("tcp"))
			o.value("tcp6",_("tcp6"))
			o.value("udp",_("udp"))
			o.value("udp6",_("udp6"))
			o.value("tcp-listen",_("tcp-listen"))
			o.value("tcp6-listen",_("tcp6-listen"))
			o.value("udp-listen",_("udp-listen"))
			o.value("udp6-listen",_("udp6-listen"))
			o = s.option(form.Value, "local_port", "Local Port")
			o = s.option(form.Value, "ssl", "SSL")
			o.rmempty = false;
			o.value("true",_("true"))
			o.value("false",_("false"))
			o = s.option(form.Value, "ssl_verify", "SSL Verify")
			o.rmempty = false;
			o.value("true",_("true"))
			o.value("false",_("false"))
			o = s.option(form.Value, "cert_file", "Cert File")
			o = s.option(form.Value, "ca_file", "CA File")
			o = s.option(form.Value, "remote_addr", "Remote Address")
			o = s.option(form.Value, "remote_port", "Remote Port")

			s = m.section(form.GridSection, "links", _("Links"));
			s.anonymous = true;
			s.addremove = true;
			s.sortable = true;

			o = s.option(form.Value, "name", "Name")
			o = s.option(form.Value, "serial", "Serial")
			o.rmempty = false;

			// Render List Options for Serial
			for (var i = 0; i < dataSerials.length; i++)
				o.value(dataSerials[i], dataSerials[i]);
			
			o = s.option(form.Value, "net", "Net")
			o.rmempty = false;

			// Render List Options for NET
			for (var i = 0; i < dataNets.length; i++)
				o.value(dataNets[i], dataNets[i]);

			o = s.option(form.Value, "in_use", "In Use")
			o.rmempty = false;
			o.value("true",_("true"))
			o.value("false",_("false"))

            return m.render()
        })

        return m;
	}
});
