'use strict';
'require view';
'require ui';
'require uci';
'require form';

return view.extend({
    render: function() {
		var m, s, o;

        m = new form.Map('snmpd')

        s = m.section(form.TypedSection, "agent", "Agent settings")
        s.anonymous = true
        o = s.option(form.Value, "agentaddress", "The address the agent should listen on",
            "[[Eg: UDP:161, or UDP:10.5.4.3:161 to only listen on a given interface]]")
    
        s = m.section(form.TypedSection, "agentx", "AgentX settings", "Delete this section to disable agentx")
        s.anonymous = true
        o = s.option(form.Value, "agentxsocket", "The address the agent should allow agentX connections to",
            "[[This is only necessary if you have subagents using the agentX socket protocol. Eg: /var/run/agentx.sock]]")
        s.addremove=true
 

		return m.render();
	}
});