'use strict';
'require uci';
'require rpc';
'require view';
'require form';
'require tools.widgets as widgets';

return view.extend({
	render: function() {
		var m, s, o;

        m = new form.Map('system');
        s = m.section(form.TypedSection, "system", _("Logging"));
		s.anonymous = true;
        o = s.option(form.Value, 'log_size', _('System log buffer size'), "Max file size: 2048 kiB")
        o.optional = true
        o.placeholder = 16
        o.datatype = 'uinteger'
        o = s.option(form.Value, 'log_ip', _('External system log server'))
        o.optional = true
        o.placeholder = '0.0.0.0'
        o.datatype = 'host'
        o = s.option(form.Value, 'log_port', _('External system log server port'))
        o.optional = true
        o.placeholder = 514
        o.datatype = 'port'
        o = s.option(form.ListValue, 'log_proto', _('External system log server protocol'))
        o.value('udp', 'UDP')
        o.value('tcp', 'TCP')
        o = s.option(form.Value, 'log_file', _('Write system log to file'))
        o.optional = true
        o.placeholder = '/tmp/system.log'
        o = s.option(form.ListValue, 'conloglevel', _('Log output level'))
        o.value(8, _('Debug'))
        o.value(7, _('Info'))
        o.value(6, _('Notice'))
        o.value(5, _('Warning'))
        o.value(4, _('Error'))
        o.value(3, _('Critical'))
        o.value(2, _('Alert'))
        o.value(1, _('Emergency'))
        o = s.option(form.ListValue, 'cronloglevel', _('Cron Log Level'))
        o.default = 8
        o.value(5, _('Debug'))
        o.value(8, _('Normal'))
        o.value(9, _('Warning'))

		return m.render();
	}
});