#!/bin/sh

[ -n "$INCLUDE_ONLY" ] || {
	. /lib/functions.sh
	. ../netifd-proto.sh
	init_proto "$@"
}
#DBG=-v

proto_qcm_init_config() {
	available=1
	no_device=1
	proto_config_add_string "device:device"
	proto_config_add_string apn
	proto_config_add_string pincode
	proto_config_add_string delay
	proto_config_add_string auth
	proto_config_add_string username
	proto_config_add_string password
	proto_config_add_int	timeout
	proto_config_add_string pdptype
	proto_config_add_defaults
}

_proto_qcm_setup() {
	local interface="$1"
	local ret

	local device apn pincode delay pdptype $PROTO_DEFAULT_OPTIONS
	json_get_vars device apn pincode delay pdptype auth username password $PROTO_DEFAULT_OPTIONS

	[ -n "$timeout" ] || timeout="10"

	[ -n "$ctl_device" ] && device=$ctl_device

	[ -n "$device" ] || {
		echo "qcm[$$]" "No control device specified"
		proto_notify_error "$interface" NO_DEVICE
#		proto_set_available "$interface" 0
		return 1
	}
	[ -c "$device" ] || {
		echo "qcm[$$]" "The specified control device does not exist"
		proto_notify_error "$interface" NO_DEVICE
#		proto_set_available "$interface" 0
		return 1
	}
	[ -n "$pdptype" ] || {
		pdptype="ipv4v6"
	}

	if [ "$pdptype" = "ipv4v6" ]; then
		option="-4 -6"
	elif [ "$pdptype" = "ipv6" ]; then
		option="-6"
	else
		option="-4"
	fi

	devname="$(basename "$device")"
	devpath="$(readlink -f /sys/class/usbmisc/$devname/device/)"
	ifname="$( ls "$devpath"/net )"

	[ -n "$ifname" ] || {
		echo "qcm[$$]" "Failed to find matching interface"
		proto_notify_error "$interface" NO_IFNAME
#		proto_set_available "$interface" 0
		return 1
	}

	[ -n "$apn" ] && {
		option="$option -s $apn"
		[ -n "$username" ] && {
			option="$option $username"
			[ -n "$password" ] && {
				option="$option $password"
			}
		}
	}

	[ -n "$pincode" ] && {
		option="$option -p $pincode"
	}

	[ -n "$delay" ] && sleep "$delay"

	echo "qcm[$$]" "connecting..."
	if ps | grep qcm_ck | grep -v grep > /dev/null; then
		kill $(ps | grep qcm_ck | grep -v grep | awk '{print $1}')
		if ps | grep quectel-CM | grep -v grep > /dev/null; then
			kill $(ps | grep quectel-CM | grep -v grep | awk '{print $1}')
		fi
	fi
	/usr/local/sbin/qcm_ck.sh "$ifname" "$option" &
#	if [ "$pdptype" = "ipv6" ]; then
#		matchcmd="ifconfig | grep -A3 \"\$ifname\" | grep \"Scope:Global\""
#	else
#		matchcmd="ifconfig | grep -A1 \"\$ifname\" | grep \"inet addr\""
#	fi
#	local uninit_timeout=0
#	while ! eval $matchcmd > /dev/null; do
#		if [ "$uninit_timeout" -lt "$timeout" ]; then
#			let uninit_timeout++
#			sleep 1
#			if ! ps | grep quectel-CM | grep -v grep > /dev/null; then
#				prog="/usr/local/sbin/quectel-CM $option"
#				$prog &
#			fi
#		else
#			if ps | grep quectel-CM | grep -v grep > /dev/nulll; then		
#				kill $(ps | grep quectel-CM | grep -v grep | awk '{print $1}')
#			fi
#			echo "qcm[$$]" "connection failed"
#	             	proto_notify_error "$interface" CONNECT_FAILED
#			return 1
#		fi
#	done

	echo "qcm[$$]" "Connected, starting DHCP"
	proto_init_update "$ifname" 1
	proto_send_update "$interface"

#	if [ "$pdptype" = "ipv4v6" ] || [ "$pdptype" = "ipv4" ]; then
#		json_init
#		json_add_string name "${interface}_4"
#		if echo "$ifname" | grep "rmnet_usb" > /dev/null; then
#			json_add_string ifname "@$interface".1
#		else
#			json_add_string ifname "@$interface"
#		fi
#		json_add_string proto "dhcp"
#		proto_add_dynamic_defaults
#		json_close_object
#		ubus call network add_dynamic "$(json_dump)"
#	fi

#	if [ "$pdptype" = "ipv4v6" ] || [ "$pdptype" = "ipv6" ]; then
#		json_init
#		json_add_string name "${interface}_6"
#		if echo "$ifname" | grep "rmnet_usb" > /dev/null; then
#			json_add_string ifname "@$interface".1
#		else
#			json_add_string ifname "@$interface"
#		fi
#		json_add_string proto "dhcpv6"
#		json_add_string extendprefix 1
#		proto_add_dynamic_defaults
#		ubus call network add_dynamic "$(json_dump)"
#	fi

}

proto_qcm_setup() {
	local ret

	_proto_qcm_setup $@
	ret=$?

	[ "$ret" = 0 ] || {
		logger "qcm bringup failed, retry in 5s"
		sleep 5
	}

	return $rt
}

proto_qcm_teardown() {
	local interface="$1"

	local device
	json_get_vars device

	[ -n "$ctl_device" ] && device=$ctl_device	

	echo "qcm[$$]" "stopping network"

	if ps | grep qcm_ck | grep -v grep > /dev/null; then
		kill $(ps | grep qcm_ck | grep -v grep | awk '{print $1}')
	fi
        if ps | grep quectel-CM | grep -v grep > /dev/null; then              
	        kill $(ps | grep quectel-CM | grep -v grep | awk '{print $1}')
        fi

	proto_init_update "*" 0
	proto_send_update "$interface"
}

[ -n "$INCLUDE_ONLY" ] || add_protocol qcm
