"use strict";
"require view";
"require form";
"require uci";
'require fs';
'require ui';

return view.extend({
	handleSaveApply: function(ev,mode) {
		return Promise.all([
			this.handleSave(ev),
			ui.changes.apply(),
			fs.exec_direct('/etc/init.d/Module_GUI', ['restart']),
			fs.exec_direct('/etc/init.d/network', ['restart'])
		]);
	},

  render: function () {
    var m, s, o;

    m = new form.Map("Module_GUI");

    s = m.section(form.TypedSection, "globals");
    s.anonymous = true;

    // o = s.option(form.DummyValue, "port", _("Port"))
    // o.rmempty = false

    o = s.option(
      form.Value,
      "interval",
      _("Interval (seconds)"),
      "The interval of sending 'AT commands' in the background."
    );
    o.rmempty = false;

    s = m.section(form.TypedSection, "FTP");
    s.anonymous = true;
    
    o = s.option(form.Flag, "enable", _("Enable"));
    o.enabled = "yes";
    o.disabled = "no";
    o.deafult = "yes";
    
    o = s.option(form.Value, "protocol", _("protocol"));
    o.rmempty = false;
    o.value("FTP", _("FTP"));
    o.default = "FTP"
    o = s.option(form.Value, "uri", _("URI"));
    o = s.option(form.Value, "file", _("File Location"));
    o = s.option(form.Value, "username", _("username"));
    o = s.option(form.Value, "password", _("password"));
    
    return m.render();
  }

});
