"use strict";
"require view";
"require form";
"require uci";
'require fs';
'require ui';

return view.extend({
	handleSaveApply: function(ev,mode) {
		return Promise.all([
			this.handleSave(ev),
			ui.changes.apply(),
			fs.exec_direct('/etc/init.d/Module_GUI', ['restart']),
			fs.exec_direct('/etc/init.d/network', ['restart'])
		]);
	},

  render: function () {
    var m, s, o;

    m = new form.Map("Module_GUI");

    s = m.section(form.GridSection, "leds");
    s.anonymous = true;
    s.addremove = false;

    o = s.option(form.DummyValue, "name", _("Name"));
    o.cfgvalue = function (section_id) {
      return section_id;
    };

    o = s.option(form.Value, "weak", _("Weak"));
    o.rmempty = false;

    o = s.option(form.Value, "medium", _("Medium"));
    o.rmempty = false;

    o = s.option(form.Value, "strong", _("Strong"));
    o.rmempty = false;
    return m.render();
  }

});
